* UTHERNET II DRIVER FOR MARINA - 12 JUL 15 - D. FINNIGAN
* - UPDATED TO USE THE NEW SEND SEQUENCE - 03 JAN 16
*
* SLOT I/O
*
 DO DEBUG
US EQU $30
 ELSE
USLOT KBD "UTHERNET II SLOT"
US EQU USLOT*16
 FIN
WMODE EQU $C084+US ; MODE REGISTER
WADRH EQU $C085+US ; ADDRESS HI-BYTE
WADRL EQU $C086+US ; "" LO-BYTE
WDATA EQU $C087+US ; R/W DATA PORT
*
* CONFIGURATION CONSTANTS
*
WINIT EQU $80 ; CHIP INIT
WOPMODE EQU $13 ; CHIP OPERATING MODE
WMEMSIZE EQU %00000011 ; 8KB TO S0
WBUFSIZE EQU 8192 ; TX AND RX BUFFERS = 8KB
WSOCKMODE EQU %01000100 ; RAW SOCKET MODE, MAC FILTER
*
* IMPORTANT W5100 LOCATIONS
*
WSHAR EQU $0009 ; SOURCE HARDWARE ADDRESS
WRMSR EQU $001A ; RX MEM SIZE
WTMSR EQU $001B ; RX MEM SIZE
WIRQR EQU $0015 ; INTERRUPT REGISTER
WIRQMR EQU $0016 ; IRQ MASK REGISTER
WRCR EQU $0019 ; RETRY COUNT
*
* SOCKET 0 LOCATIONS
*
S0MR EQU $0400 ; SOCKET 0 MODE REGISTER
S0CR EQU $0401 ; COMMAND REG
S0IR EQU $0402 ; IRQ
S0SR EQU $0403 ; STATUS
S0TXFSR EQU $0420 ; TX FREE SIZE, HI-BYTE
S0TXWR EQU $0424 ; WRITE POINTER
S0RXRSR EQU $0426 ; RX RECEIVED SIZE, HI-BYTE
S0RXRD EQU $0428 ; RX READ POINTER, HI-BYTE
*
* SOCKET 0 PARAMETERS
*
WRXBASE EQU $6000 ; SOCKET 0 RX BASE ADDR
WRXMASK EQU WBUFSIZE-1 ; SOCKET 0 8KB ADDRESS MASK
WTXBASE EQU $4000 ; SOCKET 0 TX BASE ADDR
WTXMASK EQU WRXMASK ; SOCKET 0 TX MASK = RX MASK
*
* SOCKET COMMANDS
*
SCOPEN EQU $01 ; OPEN
SCCLOSE EQU $10 ; CLOSE
SCSEND EQU $20 ; SEND
SCRECV EQU $40 ; RECV
*
* SOCKET STATUS
*
STCLOSED EQU $00 ; CLOSED
STMACRAW EQU $42 ; SOCK MACRAW
*
* MAC ADDRESS
*
OURMAC HEX 0008DC010203
*
WSLOT DFB 0 ; SLOT NUMBER IN $N0 FORMAT
FIXEDDEST DFB 0 ; NOT A FIXED DEST INTERFACE
*
* STORAGE FOR READ/WRITE POINTERS
*
WGETSIZE DS 2 ; 2 BYTES FOR RX_RSR
WGETOFFSET DS 2 ; 2 BYTES FOR OFFSET ADDR
*
* STORAGE FOR PROTOCOL HEADERS
*
OUTPHEAD
 HEX FFFFFFFFFFFF ; DESTINATION MAC
 HEX 000000000000 ; SOURCE MAC
 HEX 0800   ; ETHERTYPE IP
 HEX 450000000000
 HEX 0000FF110000
 HEX 00000000 ; IP SOURCE
 HEX FFFFFFFF ; IP DESTINATION
 DS 32 ; UDP OR TCP HEAD
*
*
* PROBE THE SLOTS TO FIND AN UTHERNET II
* THIS IS NOT USING I/O EQUATES UNTIL THE WHOLE DRIVER
* IS EVENTUALLY REWRITTEN TO BE SLOT-INDEPENDENT.
*
ETHFIND
 LDY #WSLOTLEN-WSLOTS ; NUMBER OF SLOTS TO SCAN
:L LDA WSLOTS,Y ; GET SLOT NUMBER
 TAX
*
* SEND THE RESET COMMAND
*
 LDA #WINIT
 STA $C084,X
 NOP
 NOP
 LDA $C084,X ; SHOULD GET ZERO
 BNE :NEXTSLOT
*
* CONFIGURE OPERATING MODE WITH AUTO-INCREMENT
*
 LDA #WOPMODE
 STA $C084,X
 LDA $C084,X ; READ BACK MR
 CMP #WOPMODE
 BNE :NEXTSLOT
*
* PROBE SUCCESSFUL
*
 STX WSLOT
 DO DEBUG
* SAY THAT WE'VE FOUND IT
 LDY #0
:L2 LDA MSG23,Y
 BEQ :LDONE
 JSR COUT
 INY
 BNE :L2
 FIN
:LDONE JMP ETHINIT
*
* TRY NEXT SLOT
*
:NEXTSLOT
 DEY
 BPL :L
*
* UTHERNET II NOT FOUND
*
 JMP DOSWARM
*
* SLOTS TO SCAN. THESE ARE IN REVERSE ORDER, $N0 FORMAT
*
WSLOTS HEX 70605010204030
WSLOTLEN
*
*
*
* NOW USING THE NEW SEND SEQUENCE
*
ETHSEND
 LDA #0
 STA OUTPHLEN ; NO PROTOCOL HEADERS
*
*
*
ETHSEND16
 LDA #>S0TXFSR ; CHECK TX FREE SIZE
 STA WADRH
:CHECKFREE
 LDA #<S0TXFSR
 STA WADRL
*
* IS FREE SIZE LESS THAN OUTPLEN?
*
 LDA WDATA
 LDX WDATA
 CPX OUTPLEN
 SBC OUTPLEN+1
 BCC :CHECKFREE
*
* CALCULATE OFFSET ADDRESS
* AND APPLY THE TX MASK
*
 LDA #<S0TXWR
 STA WADRL
 LDA WDATA ; HI-BYTE
 AND #>WTXMASK
 STA WGETOFFSET+1
 LDA WDATA ; LO-BYTE
 AND #<WTXMASK
 STA WGETOFFSET
*
* CALCULATE BUFFER START ADDRESS
*
 CLC
 ADC #<WTXBASE
 TAX
 LDA WGETOFFSET+1
 ADC #>WTXBASE
*
* SET BUFFER START ADDRESS ON W5100
*
 STA WADRH
 STX WADRL
*
* SEND PROTOCOL HEADERS
*
 LDA OUTPHLEN ; ANY HEADERS TO SEND?
 BEQ :SUBLEN ; NO, SO SKIP TO MAIN BUFFER
 LDX #0 ; COUNTER FOR BYTES SENT
:L LDA OUTPHEAD,X
 STA WDATA
* NEXT BYTE
 INX
 CPX OUTPHLEN
 BNE :L
*
* NOW SUBTRACT OUTPHLEN FROM OUTPLEN
*
:SUBLEN
 SEC
 LDA OUTPLEN
 SBC OUTPHLEN ; HEADER LENGTH
 STA OUTPLEN
 LDA OUTPLEN+1
 SBC #0
 STA OUTPLEN+1
*
* THIS IS WHERE WE SEND THE USER'S PACKET DATA
*
 LDY #0
 LDX OUTPLEN+1
 BEQ :END ; ONLY ONE PAGE OF DATA TO SEND
:L2 LDA (OUTPBUF),Y
 STA WDATA
 INY
 BNE :L2
 INC OUTPBUF+1
 DEX ; NEXT BLOCK OF 256 BYTES
 BNE :L2
 LDA OUTPLEN
 BEQ :DONE ; EXACT MULTIPLE OF 256
:END
 LDA (OUTPBUF),Y
 STA WDATA
 INY
 CPY OUTPLEN ; DONE YET?
 BNE :END
*
* FINISH SEND OPERATION
* INCREASE S0TXWR BY OUTPLEN + OUTPHLEN
*
:DONE
 CLC
 LDA OUTPLEN
 ADC OUTPHLEN
 STA OUTPLEN
 LDA OUTPLEN+1
 ADC #0
 STA OUTPLEN+1
*
 LDA #>S0TXWR
 STA WADRH
 LDA #<S0TXWR
 STA WADRL
 CLC
 LDA WDATA ; HIGH BYTE
 TAY
 LDA WDATA ; LOW BYTE
 ADC OUTPLEN
 TAX
 TYA
 ADC OUTPLEN+1
 TAY
 LDA #<S0TXWR
 STA WADRL
 STY WDATA ; HIGH BYTE
 STX WDATA ; LOW BYTE
*
* SET THE SEND COMMAND
*
 LDA #<S0CR
 STA WADRL
 LDA #SCSEND ; SEND
 STA WDATA
*
* CHECK SEND COMPLETION
*
:CHECKSENDOK
 LDA #<S0CR
 STA WADRL
 LDA WDATA
 BEQ :SENDOK ; 0 STATUS = SEND COMPLETE
 NOP
 BNE :CHECKSENDOK ; CHECK AGAIN
:SENDOK
 CLC
 RTS
*
*
* CHECK FOR AN INCOMING ETHERNET FRAME
*
ETHINPOLL
 LDA #>S0IR
 STA WADRH
 LDA #<S0IR
 STA WADRL
 LDA WDATA
 AND #%00000100 ; CHECK FOR RECV BIT
 BNE :GETRXRSR
:NOTHING
 SEC
 RTS
:GETRXRSR
 LDA #>S0RXRSR
 STA WADRH
 LDA #<S0RXRSR
 STA WADRL
 LDA WDATA ; GET HIGH BYTE
 ORA WDATA ; CHECK LO-BYTE
 BEQ :NOTHING
*
* THE LENGTH REPORTED BY THE W5100 INCLUDES A 2-BYTE
* DATA SIZE HEADER. WE DON'T NEED THIS, SO WE HAVE TO
* WORK AROUND IT BY ADJUSTING THE INPLEN.
*
 LDA #<S0RXRSR
 STA WADRL
 LDA WDATA ; HI-BYTE OF LEN
 STA INPLEN+1
 STA WGETSIZE+1 ; USED INTERNALLY
 SEC
 LDA WDATA ; LO-BYTE
 STA WGETSIZE
 SBC #2 ; SUBTRACT 2-BYTE LENGTH HEAD
 STA INPLEN
 LDA INPLEN+1
 SBC #0
 STA INPLEN+1
*
* COPY AN INCOMING ETHERNET FRAME FROM THE W5100
*
ETHRECV
 INC RNDL
 BNE :NEXT
 INC RNDH
:NEXT
 LDA #0
 STA INPBUF
 LDA #$50
 STA INPBUF+1
*
* CALCULATE OFFSET ADDRESS USING READ POINTER AND RX MASK
*
 LDA #<S0RXRD
 STA WADRL
 LDA WDATA ; HI-BYTE
 AND #>WRXMASK
 STA WGETOFFSET+1
 LDA WDATA ; LO-BYTE
 AND #<WRXMASK
 STA WGETOFFSET
*
* CALCULATE PHYSICAL ADDRESS WITHIN W5100 RX BUFFER
*
 CLC
 ADC #<WRXBASE
 TAX
 LDA WGETOFFSET+1
 ADC #>WRXBASE
*
* SET BUFFER ADDRESS ON W5100
*
 STA WADRH
 STX WADRL
*
* BEGIN COPY
*
 LDY #0
 LDX WGETSIZE+1
 BEQ :LAST ; LESS THAN 256 BYTES
:L LDA WDATA
 STA (INPBUF),Y
 INY
 BNE :L
 INC INPBUF+1
 DEX
 BNE :L
:LAST
 LDX WGETSIZE
:L2 LDA WDATA
 STA (INPBUF),Y
 INY
 DEX
 BNE :L2
*
* UPDATE RXRD TO REFLECT DATA WE JUST READ
*
:UPDATERXRD
 CLC
 LDA #>S0RXRD ; NEED HIGH BYTE HERE
 STA WADRH
 LDA #<S0RXRD
 STA WADRL
 LDA WDATA ; HIGH BYTE
 TAY ; SAVE
 LDA WDATA ; LOW BYTE
 ADC WGETSIZE ; ADD LOW BYTE OF RECEIVED SIZE
 TAX ; SAVE
 TYA ; GET HIGH BYTE BACK
 ADC WGETSIZE+1 ; ADD HIGH BYTE OF RECEIVED SIZE
 TAY  ; SAVE
 LDA #<S0RXRD
 STA WADRL
 STY WDATA ; SEND HIGH BYTE
 STX WDATA ; SEND LOW BYTE
*
* SET RECV COMMAND
*
 LDA #<S0CR
 STA WADRL
 LDA #SCRECV ; RECV
 STA WDATA
*
* ADVANCE INPBUF PAST THE 2-BYTE LENGTH HEADER
* JUST SET IT TO $5002 FOR NOW
 LDA #2
 STA INPBUF
 LDA #$50
 STA INPBUF+1
*
* CHECK FOR LINK LAYER BROADCAST
*
:CHECKBCAST
 LDA #0
 STA LLBCASTFLAG
 LDA #$FF
 LDY #5
:CHKBL AND (INPBUF),Y
 DEY
 BPL :CHKBL
 CMP #$FF
 BNE :DONE
* IS A BROADCAST
 STA LLBCASTFLAG ; SHOULD BE $FF
:DONE CLC
 RTS
*
* INITIALIZE THE W5100
* NOTE: SOME OF THESE PROCEDURES WERE ALREADY DONE IN
* THE PROBING LOOP EARLIER.
*
ETHINIT
 LDA #WINIT ; INITIALIZE THE W5100
 STA WMODE
 LDA #WOPMODE
 STA WMODE
*
* CONFIGURE MAC ADDRESS
*
ASSIGNMAC
 LDA #>WSHAR
 STA WADRH
 LDA #<WSHAR
 STA WADRL
 LDX #0
:L LDA OURMAC,X
 STA WDATA
 INX
 CPX #6
 BNE :L
*
* CONFIGURE BUFFER SIZE
*
 LDA #<WRMSR
 STA WADRL
 LDA #WMEMSIZE
 STA WDATA ; SET RX BUFFER SIZE
 STA WDATA ; ASSUME AUTO-INC TO SET TX BUFFER SIZE
*
* SET IRQ MASK
*
 LDA #<WIRQMR
 STA WADRL
 LDA #0 ; MASK ALL INTERRUPTS
 STA WDATA
*
* INITIALIZE SOCKET 0
*
:INIT0
 LDA #>S0MR
 STA WADRH
 LDA #<S0MR
 STA WADRL
 LDA #WSOCKMODE ; CONFIGURE MAC RAW MODE
 STA WDATA
* OPEN SOCKET 0
 LDA #SCOPEN ; OPEN
 STA WDATA ; AUTO-INC NOW AT CR
*
* CHECK FOR OK STATUS
*
 LDA #<S0SR
 STA WADRL
 LDA WDATA ; CHECK STATUS, SHOULD BE...
 CMP #STMACRAW ; SOCK_MACRAW
 BNE :RETRY
 CLC  ; NO ERROR
 RTS
:RETRY
 LDA #<S0CR
 STA WADRL
 LDA #SCCLOSE ; CLOSE
 STA WDATA
 BNE :INIT0 ; TRY TO INIT AGAIN
